﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private AvatarBL _AvatarBL = null;

        public AvatarBL Avatar
        {
            get
            {
                if (_AvatarBL == null)
                {
                    _AvatarBL = new AvatarBL(this);
                }

                return _AvatarBL;
            }
        }

        public class AvatarBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public AvatarBL(ZSBELearning BL) : base(BL) { }


            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.ExerciseAvatar.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public XmlDocument Get(PI.GM.N610.ELearning.BL.BO.Exercise Exercise,XmlDocument XmlExercise,PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType Event)
            {
                if (Exercise != null)
                {
                    string _imageURL = string.Empty;
                    string _text = string.Empty;
                    int? _width = null;

                    PI.ZB.N1200.ELearning.BL.BO.ExerciseAvatar _exerciseAvatar = BLP.Avatar.RestoreRandom(Exercise.Type, Event);
                    if (_exerciseAvatar != null)
                    {
                        _imageURL = _exerciseAvatar.ImageFileURL;
                        _text = _exerciseAvatar.Text;
                    }
                    else
                    {
                        _imageURL = GetDefaultURL(Event);
                        _text = GetDefaultText(Event);
                    }

                    if (!String.IsNullOrEmpty(_imageURL))
                    {
                        XmlNode _xmlAvatar = Gemini.Utility.XML.Node.Add(XmlExercise, Dictionary.XMLNodes.Avatar, true);
                        Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlAvatar, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ImageURL, _imageURL);

                        _width = BLP.RBL.VariableRepository.GetInt(Dictionary.Config.Avatar.Width, Dictionary.Clients.PlugIn);

                        if (_width.HasValue)
                        {
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlAvatar, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.Width, _width);
                        }

                        if (!String.IsNullOrEmpty(_text))
                        {
                            _text = _text.Replace(Dictionary.Avatar.User, BLP.Environment.User.DisplayNickname);

                            if (Event == GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Check)
                            {
                                if (Exercise.MaxPoints.HasValue)
                                {
                                    _text = _text.Replace(Dictionary.Avatar.MaxPoint, Exercise.MaxPoints.ToString());
                                }

                                if (Exercise.TmpPoints.HasValue)
                                {
                                    _text = _text.Replace(Dictionary.Avatar.Point, Exercise.TmpPoints.ToString());
                                }
                            }

                            Gemini.Utility.XML.Node.Set.CDATA(XmlExercise, _xmlAvatar, _text);
                        }
                    }
                }
                return XmlExercise;
            }

            private string GetDefaultURL(PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType Event)
            {
                string _imageURL = string.Empty;

                switch (Event)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Load:
                        _imageURL = BLP.RBL.VariableRepository.GetString(Dictionary.Config.Avatar.Load.ImageURL, Dictionary.Clients.PlugIn);
                        break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Check:
                        _imageURL = BLP.RBL.VariableRepository.GetString(Dictionary.Config.Avatar.Check.ImageURL, Dictionary.Clients.PlugIn);
                        break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Resolve:
                        _imageURL = BLP.RBL.VariableRepository.GetString(Dictionary.Config.Avatar.Resolve.ImageURL, Dictionary.Clients.PlugIn);
                        break;
                }

                return _imageURL;
            }

            private string GetDefaultText(PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType Event)
            {
                string _text = string.Empty;

                switch (Event)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Load:
                        _text = BLP.RBL.VariableRepository.GetString(Dictionary.Config.Avatar.Load.Text, Dictionary.Clients.PlugIn);
                        break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Check:
                        _text = BLP.RBL.VariableRepository.GetString(Dictionary.Config.Avatar.Check.Text, Dictionary.Clients.PlugIn);
                        break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Resolve:
                        _text = BLP.RBL.VariableRepository.GetString(Dictionary.Config.Avatar.Resolve.Text, Dictionary.Clients.PlugIn);
                        break;
                }

                return _text;
            }

            public List<BL.BO.ExerciseAvatar> Restore()
            {
                ELearning.BL.BO.ExerciseAvatar.Search _search = new BO.ExerciseAvatar.Search();
                return BLP.DAL.ExerciseAvatar.Restore(_search);
            }

            public BL.BO.ExerciseAvatar Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BL.BO.ExerciseAvatar _ExerciseAvatar = null;

                if ((BO != null) && (BO.ID.HasValue))
                {
                    _ExerciseAvatar =  BLP.DAL.ExerciseAvatar.Restore(BO.ID);
                }

                return _ExerciseAvatar;
            }

            public BL.BO.ExerciseAvatar Restore(long? ID)
            {
                BL.BO.ExerciseAvatar _ExerciseAvatar = null;

                if (ID.HasValue)
                {
                    _ExerciseAvatar = BLP.DAL.ExerciseAvatar.Restore(ID);
                }

                return _ExerciseAvatar;
            }

            public BL.BO.ExerciseAvatar RestoreRandom(PI.GM.N610.ELearning.BL.Dictionary.Exercise.Types ExerciseType, PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType EventType)
            {
                ELearning.BL.BO.ExerciseAvatar.Search _search = new BO.ExerciseAvatar.Search();
                _search.ExerciseTypeID = (int)ExerciseType;
                _search.ExerciseEventID = (int)EventType;

                return BLP.DAL.ExerciseAvatar.RestoreRandom(_search);
            }

            public Gemini.Core.BL.Base.MethodResult Save(BL.BO.ExerciseAvatar ExerciseAvatar)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (ExerciseAvatar == null)
                {
                    _methodResult.SetSuccess = false;
                }
                else
                {
                    if (ExerciseAvatar.ID.HasValue)
                    {
                        _methodResult.SetSuccess = BLP.DAL.ExerciseAvatar.Update(ExerciseAvatar);
                    }
                    else
                    {
                        _methodResult.SetSuccess = BLP.DAL.ExerciseAvatar.Create(ExerciseAvatar);
                    }
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BL.BO.ExerciseAvatar ExerciseAvatar)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (ExerciseAvatar != null)
                {
                    try
                    {
                        _methodResult.SetSuccess = BLP.DAL.ExerciseAvatar.Remove(ExerciseAvatar);
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(_exeption);
                    }
                }
                return _methodResult;
            }

            public BL.BO.ExerciseAvatar Create(PI.GM.N610.ELearning.BL.Dictionary.Exercise.Types ExerciseType, PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType EventType)
            {
                BL.BO.ExerciseAvatar _ExerciseAvatar = BLP.DAL.ExerciseAvatar.New();

                _ExerciseAvatar.ExerciseEventID = (int)EventType;
                _ExerciseAvatar.ExerciseTypeID = (int)ExerciseType;

                BLP.DAL.ExerciseAvatar.Create(_ExerciseAvatar);

                return _ExerciseAvatar;
            }
        }
    }
}
